Namespace myapp

#Import "<std>"
#Import "<mojo>"
#Import "polytools.monkey2"


Using std..
Using mojo..
Using polytools..

Class MyWindow Extends Window
	
	Field poly:Vec2d[]
	Field polyStack:Stack<Vec2d[]>
	Field tpoly:Stack<Vec2d>
	Field currentV:Int
	Field zoom:=88.0
	Field follow:=False
	
	Field state:="init"

	Method New( title:String="Simple mojo app",width:Int=940,height:Int=580,flags:WindowFlags=Null )

		Super.New( title,width,height,flags )
		tpoly=New Stack<Vec2d>
		state="init"
		
	End

	Method OnRender( canvas:Canvas ) Override
	
		App.RequestRender()
		
		If state="init"
			
			Local mouseLoc:Vec2i=MouseLocation
			
			canvas.DrawText(" lenght"+tpoly.Length+" Draw any poly, press Spacebar to finish" ,10,10)
			If Keyboard.KeyPressed(Key.Space)
				
				If tpoly.Length>2
					
					state="check"
					tpoly.Add(tpoly[0])
					poly=tpoly.ToArray()

					polyStack=cleanPolygon(poly)
					
				End
				
			End
			
			If Mouse.ButtonDown(MouseButton.Left)
				
				If Not tpoly.Empty
					If tpoly.Top.Distance(mouseLoc)>3 Then tpoly.Add(mouseLoc)
				Else
					tpoly.Add(mouseLoc)
				End
			End 
			
			If tpoly.Length>1
				For Local i:=0 Until tpoly.Length-1
					canvas.DrawLine(tpoly[i],tpoly[i+1])
				Next
			End
			
		Elseif state="check"
			
			canvas.PushMatrix()
			
			canvas.Color=New Color(0.5,0,0)
			For Local i:=0 Until poly.Length-1
				canvas.DrawLine (poly[i],poly[i+1])
			Next
			canvas.DrawLine (poly[0],poly[poly.Length-1])
			
			canvas.Color=Color.Red
			
			If polyStack.Length>0
				For Local i:=0 Until polyStack.Length
					canvas.Color=New Color(Sin(i/11.0),Cos(i*7.0),Sin(1-5*i)*0.4)
					If polyStack[i].Length>0
						Local sPoly:=polyStack[i]
						For Local j:=0 Until sPoly.Length-1
							canvas.DrawLine(sPoly[j],sPoly[j+1])
						Next
						canvas.DrawLine (sPoly[sPoly.Length-1],sPoly[0])
					End
				Next
			End
			
			canvas.PopMatrix()
			
			Local p:=Mouse.Location

			canvas.DrawText("mouse: "+p,10,20)

		End
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End




