// //////////////////////////////////////////////////////////
// tests.cpp
// Copyright (c) 2015 Stephan Brumme. All rights reserved.
// see http://create.stephan-brumme.com/disclaimer.html
//

// simple test suite for hash-library
// g++ tests.cpp ../crc32.cpp ../md5.cpp ../sha1.cpp ../sha256.cpp ../sha3.cpp -o tests && ./tests

#include "hashes_for_mx2.h"

//#include "crc32.h"
//#include "md5.h"
//#include "sha1.h"
#include "sha256.h"
//#include "sha3.h"

#include "hmac.h"

#include <string>

//#include <vector>

#include <iostream>


void hmac256( const char* data_cstr, const char* key_cstr, char* digest_cstr)
{

  std::string str = hmac<SHA256>(data_cstr, key_cstr);
  std::copy(str.begin(), str.end(), digest_cstr);
  digest_cstr[str.size()] = '\0'; // don't forget the terminating 0

}
