
#Import "<std>"
#Import "<mojo>"
#Import "<mojo3d>"
#Import "assets/"

#Rem
	
	Model:
	
		https://poly.google.com/view/ah8WSBbizA6
		Author: Poly by Google
		License: CC-BY
		Rocketship
		
	Sounds:
	
		Generated in Bfxr
		
#End

Using std..
Using mojo..
Using mojo3d..

#If __TARGET__ = "emscripten"
	Const TRI_SKIPPER:Int = 3 ' Skip every TRI_SKIPPER triangles for speed -- used in model.Collided Lambda
#Else
	Const TRI_SKIPPER:Int = 2
#Endif

' TODO: Smoke particle cleanup after death, not instant delete

' Collision types

Const COLL_NOTHING:Short			= 0
Const COLL_TERRAIN:Short			= 1
Const COLL_ROCKET:Short				= 2
Const COLL_ORB:Short				= 4
Const COLL_SMOKE:Short				= 8
Const COLL_PAD:Short				= 16
Const COLL_TRI:Short				= 32

' Collision groups

Const TERRAIN_COLLIDES_WITH:Short	= COLL_ROCKET	| COLL_ORB	| COLL_SMOKE	| COLL_TRI
Const ROCKET_COLLIDES_WITH:Short	= COLL_TERRAIN	| COLL_PAD
Const ORB_COLLIDES_WITH:Short		= COLL_TERRAIN	| COLL_PAD
Const SMOKE_COLLIDES_WITH:Short		= COLL_TERRAIN	| COLL_PAD
Const PAD_COLLIDES_WITH:Short		= COLL_ROCKET	| COLL_ORB	| COLL_SMOKE	| COLL_TRI
Const TRI_COLLIDES_WITH:Short		= COLL_TERRAIN	| COLL_PAD

#Rem
Working well here on chrome/nightly, windows 10, 60fps all the way. Like all games
these days, too freakin’ hard for me though!

    My rocket keeps rotating, but I can’t see that we have (at least Monkey-side)
    angular damping

Will add linear/angular damping for next release.

    Can we have fixed constraints added?

Will add eventually. Are you using ApplyImpulse for thrust? Have you looked at the
ApplyImpulse( dir:Vec3f,offset:Vec3f ) version? This should allow you to provide off centre,
‘local space’ thrust, ie: offset is similar to LocalPosition for child entities.

    Unrelated: how do you export PixelFormat.I8 from a paint program?

I use paint.net and save as 8bit png.

    is there a way to detect collision at the moment?

Yes, see: Entity.Collided. I did have it going in tests/shapes.monkey2 at one point,
but it’s commented out now I think. Still, should show you roughly how to use it.

#end

' ----------------------------------------
' Radians to degrees helper...
' ----------------------------------------

Global RadDivider:Float = Pi / 180.0

Function Degrees:Float (radian:Float)
	Return radian * RadDivider
End

Function DrawCross:Void (canvas:Canvas, x:Float, y:Float, size:Float = 9.0)

	canvas.DrawLine (x - size * 0.5, y, x + size * 0.5, y)
	canvas.DrawLine (x, y - size * 0.5, x, y + size * 0.5)

End

Class SpaceGem

	Global SpaceGemList:List <SpaceGem>
	
	Global Collected:Sound
	Global Collected_Channel:Channel
	
	Field model:Model				' mojo3d Model
	
	Field light:Light
	
	Method New (x:Float, y:Float, z:Float, size:Float = 1.0, color:Color = Null)
	
		If Not SpaceGemList Then SpaceGemList = New List <SpaceGem>
		
		If Not Collected Then Collected = Sound.Load ("asset::collected.ogg")
		
		Local box:Boxf = New Boxf (-size * 0.5, -size * 0.5, -size * 0.5, size * 0.5, size * 0.5, size * 0.5)
		
		If Not color Then color = Color.Red
		
		model = Model.CreateBox (box, 1, 1, 1, New PbrMaterial (color))
		Cast <PbrMaterial> (model.Material).MetalnessFactor = 1.0

		light = New Light (model)
		light.Type = LightType.Spot ' Directional ' Point
		light.Rotate (90.0, 0.0, 0.0) ' Spotlight down
		light.InnerAngle = 0.0
		light.OuterAngle = 45.0
		light.CastsShadow = True
		light.Color = color * 4.0
		light.Range = 15.0

		model.Move (x, y + size * 3.0, z)
		model.Alpha = 0.5
		model.Rotate (Rnd (45.0), Rnd (45.0), Rnd (45.0))
		
		SpaceGemList.AddLast (Self)
		
	End
	
End

Class Pad

	Field model:Model				' mojo3d Model
	Field collider:BoxCollider		' Bullet physics collider
	Field body:RigidBody			' Bullet physics body

	Method New (x:Float, y:Float, z:Float, size:Float = 8.0, gemcolor:Color = Null)
	
		Local box:Boxf = New Boxf (-size * 0.5, -1.0, -size * 0.5, size * 0.5, 1.0, size * 0.5)
		
		model = Model.CreateBox (box, 2, 2, 2, New PbrMaterial (Color.Grey))
'		Cast <PbrMaterial> (model.Material).EmissiveFactor = Color.White * 0.5
		Cast <PbrMaterial> (model.Material).MetalnessFactor = 1.0
		
		model.Move (x, y, z)
		
		If gemcolor <> Null
			Local sg:SpaceGem = New SpaceGem (x, y, z, size * 0.5, gemcolor)
		Endif
		
		collider = model.AddComponent <BoxCollider> ()
		collider.Box = box

		body = model.AddComponent <RigidBody> ()
		body.Mass = 0.0

		body.CollisionMask	= COLL_PAD
		body.CollisionGroup	= PAD_COLLIDES_WITH
		
	End
	
End

Function ModelFromTriangle:Model (in_model:Model, index:UInt, mat_index:Int)

		Local mesh:Mesh = in_model.Mesh
		
		Local tri_model:Model = New Model
	
		Assert (mat_index < in_model.Mesh.NumMaterials, "Material index too high")
		
		tri_model.Material = in_model.Materials [mat_index]
		
'		If in_model.Material
'		
'			tri_model.Material = in_model.Material' New PbrMaterial (Color.Red)
'
		tri_model.Material.CullMode = CullMode.None
'
'		Else
'			
'			' Temp material
'			
'			tri_model.Material = New PbrMaterial (Color.White)
'			
' 		Endif
' 			
		Assert (index + 2 < mesh.NumIndices, "Index too high") ' Think that's right...
		
'		For Local mat_indices:Int = 0 Until in_model.Mesh.NumMaterials
		
		Local indices:UInt [] = mesh.GetIndices (mat_index)
'		Print indices.Length
		
		Local tri_verts:Vertex3f [] = New Vertex3f [3]
		
			' mesh-local co-ords...
			
			'Print index + " of " + mesh.NumIndices
			tri_verts [0] = mesh.GetVertex (indices [index + 0])
			tri_verts [1] = mesh.GetVertex (indices [index + 1])
			tri_verts [2] = mesh.GetVertex (indices [index + 2])
		
		Local tri_indices:UInt [] = New UInt [3]
		
			tri_indices [0] = 0
			tri_indices [1] = 1
			tri_indices [2] = 2
		
		Local tri_mesh:Mesh = New Mesh (tri_verts, tri_indices)
		
		tri_mesh.UpdateNormals ()
		tri_mesh.UpdateTangents ()
 
		tri_model.Mesh = tri_mesh
 
 		tri_model.Parent = in_model
 		
	Return tri_model
 
End

Class PhysicsTri

	Field model:Model
	Field body:RigidBody
	Field collider:BoxCollider
	
	Global PhysicsTriList:List <PhysicsTri>
	
	Method New ()
	
		If Not PhysicsTriList Then PhysicsTriList = New List <PhysicsTri>
		PhysicsTriList.AddLast (Self)
		
	End

	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
	End

End

Class Rocket

	Field model:Model				' mojo3d Model
	Field collider:ConeCollider		' Bullet physics collider
	Field body:RigidBody			' Bullet physics body

	Field boost_factor:Float	= 0.25
	Field torque_factor:Float	= 2.0

	Field vec_forward:Vec3f
	Field vec_backward:Vec3f
	Field vec_left:Vec3f
	Field vec_right:Vec3f

	Field boost:Sound
	Field boost_channel:Channel
	
	Field alert:Sound
	Field alert_channel:Channel
	
	Field boom:Sound
	Field boom_channel:Channel
	
	Field refuel:Sound
	Field refuel_channel:Channel
	
'	Field booster:Light
	
	Field fuel:Float = 100.0
	Field exploded:Bool = False
	
	Field landed:Bool = False
	
	Method New (x:Float, y:Float, z:Float, radius:Float, length:Float, mass:Float)
		
		Local mat:PbrMaterial = New PbrMaterial (Color.Silver)
		mat.MetalnessFactor = 0.85
		
		boost = Sound.Load ("asset::boost.ogg")
		boost_channel = boost.Play (True)
		boost_channel.Volume = 0.0
		
		alert = Sound.Load ("asset::alert.ogg")
		alert_channel = alert.Play (True)
		alert_channel.Volume = 0.0
		
		boom = Sound.Load ("asset::boom.ogg")
		boom_channel = boom.Play (False)
		boom_channel.Paused = True
'		boom_channel.Volume = 0.0

' Can't detect when leaving pad!

'		refuel = Sound.Load ("asset::refuel.ogg")
'		refuel_channel = refuel.Play (True)
		'refuel_channel.Rate = refuel_channel.Rate * 0.85
'		refuel_channel.Volume = 0.0
		
		model = Model.Load ("asset::Rocket_Ship_01.gltf")

		For Local mat:Material = Eachin model.Materials
			Cast <PbrMaterial> (mat).MetalnessFactor = 1.0
		Next
		
'		cone vis:
		
		'Local temp:Model = Model.CreateCone (radius, length, Axis.Y, 32, mat, model)
		'temp.Alpha = 0.25
		
		Local yoff:Float = 0.15
		model.Mesh.FitVertices (New Boxf (-radius, -length * 0.5 - yoff, -radius, radius, length * 0.5 - yoff, radius), False)
		
		' Hmm...
		
'		booster = New Light (model)
'		booster.Type = LightType.Spot ' Directional ' Point
'		booster.Move (0, -2.0, 0)
'		booster.Rotate (90.0, 0.0, 0.0) ' Spotlight down
'		booster.InnerAngle = 5.0
'		booster.OuterAngle = 15.0
'		booster.CastsShadow = True
'		booster.Color = Color.Black
'		booster.Range = 25.0
'		
		' Important: Position BEFORE adding collider/rigid body!
		
		model.Move (x, y + length, z)

		' Add collider shape and rigid body...
		
		collider			= model.AddComponent <ConeCollider> ()
		collider.Radius		= radius
		collider.Length		= length

		body				= model.AddComponent <RigidBody> ()
 		body.Mass			= mass
		body.Restitution	= 0.1
		
		body.AngularDamping	= 0.85
		body.LinearDamping	= 0.2
		
		body.CollisionMask	= COLL_ROCKET
		body.CollisionGroup	= ROCKET_COLLIDES_WITH

		vec_forward			= New Vec3f (torque_factor, 0.0, 0.0)
		vec_backward		= New Vec3f (-torque_factor, 0.0, 0.0)
		vec_left			= New Vec3f (0.0, 0.0, torque_factor)
		vec_right			= New Vec3f (0.0, 0.0, -torque_factor)

		model.Collided += Lambda (other_body:RigidBody) ' Other colliding body
			
			Select other_body.CollisionMask
			
				Case COLL_PAD
				
					' Landing speed check... TODO: Angle!
					
'					If body.LinearVelocity.Length < 3.0 Then Return ' TODO: Need explosion on pad too
		
					If Not landed
						landed = True ' Can't detect when no longer colliding!
						' Want to play landing 'thump' once
					Endif
				
					fuel = fuel + 0.25
					
					'refuel_channel.Volume = 0.1
					
					If alert_channel.Volume
						If fuel > 25.0 Then alert_channel.Volume = 0.0
					Endif
					
					' Refuel is now max 50%
					 
					If fuel > 100 Then fuel = 100'; refuel_channel.Volume = 0.0
				
				Case COLL_TERRAIN

					' Landing speed check... TODO: Angle!
					
					If fuel > 0.0
						If body.LinearVelocity.Length < 3.0 Then Return
					Endif
		
					If exploded Then Return
					
					boom_channel.Paused = False
					alert_channel.Paused = True
					
					Local fuel_boost:Float = Max (3.0, fuel * 0.05)
					
					For Local mat:Int = 0 Until model.Mesh.NumMaterials
					
						For Local loop:UInt = 0 Until model.Mesh.GetIndices (mat).Length Step 3 * TRI_SKIPPER
							
							Local ptri:PhysicsTri = New PhysicsTri
							
							ptri.model = ModelFromTriangle (model, loop, mat)
							
							ptri.model.Parent = Null
							
#If __TARGET__ = "emscripten"

							ptri.model.CastsShadow = False
#Endif
							ptri.collider = ptri.model.AddComponent <BoxCollider> ()
							ptri.collider.Box = ptri.model.Mesh.Bounds
							
							ptri.body					= ptri.model.AddComponent <RigidBody> ()
							ptri.body.Mass				= 1.0
							ptri.body.Restitution		= 0.25
							ptri.body.Friction			= 0.5
							ptri.body.AngularDamping	= 1.0
				
							ptri.body.CollisionMask = COLL_TRI
							ptri.body.CollisionGroup = TRI_COLLIDES_WITH
							
							Local power:Float = 5.0
							
							' Working circular:
							
'							ptri.body.ApplyImpulse (body.LinearVelocity + (model.Basis * New Vec3f (Rnd (-1.0, 1.0), Rnd (-1.0, 1.0), Rnd (-1.0, 1.0))).Normalize () * power)
							
							Local tri_mesh:Mesh = ptri.model.Mesh
							
							Local vert0:Vertex3f = tri_mesh.GetVertex (0)
							Local vert1:Vertex3f = tri_mesh.GetVertex (1)
							Local vert2:Vertex3f = tri_mesh.GetVertex (2)
							
							' Tri centre...
							
							Local centroid:Vec3f = (vert0.position + vert1.position + vert2.position) / 3.0
							
							ptri.body.ApplyImpulse (body.LinearVelocity + (centroid.Normalize () * fuel_boost * Rnd (2.5)))

							' Crumble!
'							ptri.body.ApplyImpulse (body.LinearVelocity)

						Next
					
					Next

					model.Visible = False
					
					exploded = True
					fuel = 0.0

			End
			
		End
		
	End

	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
		boost_channel.Stop ()
		alert_channel.Stop ()
		boom_channel.Stop ()
		boost_channel = Null
		alert_channel = Null
		boom_channel = Null
	End

	Method Boost:Void (force_x:Float = 0.0, force_y:Float = 0.0, force_z:Float = 0.0)
		body.ApplyImpulse (model.Basis * New Vec3f (force_x, force_y, force_z))
	End

	Method PitchLeft:Void (camera:Camera, multi:Float = 1.0)
		body.ApplyTorqueImpulse (camera.Basis * vec_left * multi)
	End

	Method PitchRight:Void (camera:Camera, multi:Float = 1.0)
		body.ApplyTorqueImpulse (camera.Basis * vec_right * multi)
	End

	Method PitchForward:Void (camera:Camera, multi:Float = 1.0)
		body.ApplyTorqueImpulse (camera.Basis * vec_forward * multi)
	End

	Method PitchBack:Void (camera:Camera, multi:Float = 1.0)
		body.ApplyTorqueImpulse (camera.Basis * vec_backward * multi)
	End

End

Class Orb

	Field model:Model
	Field body:RigidBody
	Field collider:SphereCollider

	Field glow:Light
	
	Field constraint:BallSocketJoint

	Method New (rocket:Rocket, distance:Float, mass:Float = 1.0)

		Local mat:PbrMaterial = New PbrMaterial (Color.HotPink)
		
		model			= Model.CreateSphere (0.75, 32, 32, mat)
		
		' Position model BEFORE adding physics components; set here
		' to rocket position less 'distance' below...
		
		#Rem
		
		
			^		ROCKET			constraint.Pivot				This is the BALL socket (at rocket position)
			|
			|
			|		distance
			|
			|
			O		ORB				constraint.ConnectedPivot		This is a FIXED point (at orb position)
			
			
		#End
		
		model.Position				= rocket.model.Position + New Vec3f (0.0, -distance, 0.0)
		
		model.CastsShadow = False
		
		glow = New Light (model)
		
		glow.Type = LightType.Spot ' Directional ' Point
		glow.Rotate (90.0, 0.0, 0.0) ' Spotlight down
		glow.InnerAngle = 0.0
		glow.OuterAngle = 10.0
		glow.CastsShadow = True
		glow.Color = Color.HotPink * 8.0'HotPink
		glow.Range = 50.0
		
		
		body						= model.AddComponent <RigidBody> ()
		collider					= model.AddComponent <SphereCollider> ()

		body.Mass					= mass
		body.Restitution			= 0.5

		body.CollisionMask			= COLL_ORB
		body.CollisionGroup			= ORB_COLLIDES_WITH

		constraint					= model.AddComponent <BallSocketJoint> ()
		
		' constraint.Pivot at ROCKET position (upwards by 'distance')...
		
		' BALL SOCKET
		
		constraint.Pivot			= New Vec3f (0.0, distance, 0.0)

		' constraint.ConnectedPivot at ORB position (0, 0, 0 relative to orb)...
		
		' FIXED POINT
		
'		constraint.ConnectedPivot	= New Vec3f (0.0, 0.0, 0.0)
		
		' But constraint.ConnectedBody is the ROCKET body here... all a matter of
		' perspective, since you could have the ball socket (Pivot) at orb position
		' instead...
		
		constraint.ConnectedBody	= rocket.body
		
	End

	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
	End

End

Class SmokeParticle

	Global ParticleList:List <SmokeParticle>
	
	Field model:Model
	Field body:RigidBody
	Field collider:BoxCollider

	Field thrust:Vec3f

	Method New (rocket:Rocket, multi:Float = 1.0)

		If Not ParticleList
			ParticleList = New List <SmokeParticle>
		Endif
		
		If Not thrust
			thrust = New Vec3f (0.0, -30.0 * multi, 0.0)
		Endif
		
		Local col:Color
		
		Select Int (Rnd (5))
		
			Case 0
				col = Color.Black
			Case 1
				col = Color.White
			Case 2
				col = Color.Red
			Case 3
				col = Color.Orange
			Case 4
				col = Color.Yellow
		End
		
		'rocket.booster.Color = col * 4.0 * multi
		
		Local mat:PbrMaterial = New PbrMaterial (col)
		
		Local size:Float = 0.5
		Local distance:Float = 10.0
		
		model						= Model.CreateBox (New Boxf (-size * 0.5, -size * 0.5, -size * 0.5, size * 0.5, size * 0.5, size * 0.5), 2, 2, 2, mat, rocket.model)
		
		'model.Position				= rocket.model.Position + New Vec3f (0.0, -distance, 0.0) + New Vec3f (Rnd (-1.0, 1.0), Rnd (0.0, 5.0), Rnd (-1.0, 1.0))
		model.Move (Rnd (-1.0, 1.0), -Rnd (2.5, 3.5), Rnd (-1.0, 1.0))
		
		model.Alpha					= 1.0
		
		body						= model.AddComponent <RigidBody> ()
		collider					= model.AddComponent <BoxCollider> ()

		body.Mass					= 0.01
		body.Restitution			= 0.5
		body.Friction				= 0.1
		
		body.ApplyImpulse (rocket.model.Basis * thrust)
		
'		body.CollisionMask = 0

		body.CollisionMask	= COLL_SMOKE
		body.CollisionGroup	= SMOKE_COLLIDES_WITH
		
		ParticleList.AddLast (Self)
		
	End

End

Class Ground ' WIP! Add physics, etc...

	Field ground:Model
	Field ground_pixels:Pixmap

	Field heightmap:Pixmap
	Field terrain_material:PbrMaterial

	Field height_box:Boxf
	
	Method LoadTerrain:Model (hmap:String)

		Local ground_pixels:Pixmap = New Pixmap (256, 256, PixelFormat.RGBA8)
		ground_pixels.Clear (Color.Green * 0.5)
		
		Local pixel_toggle:Int = 0
		
		For Local gp_y:Int = 0 Until ground_pixels.Height
			For Local gp_x:Int = 0 Until ground_pixels.Width
				If pixel_toggle Then ground_pixels.SetPixel (gp_x, gp_y, Color.SeaGreen * New Color (1.0, 1.2, 0.75))
				pixel_toggle = 1 - pixel_toggle
			Next
			pixel_toggle = 1 - pixel_toggle
		Next
		
		heightmap = Pixmap.Load (hmap)
		
		If heightmap.Format <> PixelFormat.I8
			Print ""
			Print "*** MEDIA WARNING: Converting heightmap; should be supplied in PixelFormat.I8 format! (See PixelFormat docs.) ***"
			Print ""
			heightmap = heightmap.Convert (PixelFormat.I8)
			'Print heightmap.Save ("C:/Users/James/Desktop/height.png") ' Returns True if saved to asset:: even though it fails!
		Endif
		
		Local terrain_material:PbrMaterial = New PbrMaterial ()
		terrain_material.ColorTexture = New Texture (ground_pixels, TextureFlags.None)
		
		Local terrain_height:Float = 64.0
		
		height_box = New Boxf (-heightmap.Width * 0.5, 0, -heightmap.Height * 0.5, heightmap.Width * 0.5, terrain_height, heightmap.Height * 0.5)

		Return Model.CreateTerrain (heightmap, height_box, terrain_material)
		
	End
	
End

Class Game Extends Window

	Const CAMERA_MOVE:Float = 0.05
	Const SHIFT_BOOST:Float = 4.0

	Field cam_boost:Float = 1.0
 	
	Field scene:Scene

	Field cam:Camera

	Field light:Light

	Field ground:Model
	Field ground_pixels:Pixmap

	Field heightmap:Pixmap
	Field terrain_material:PbrMaterial

	Field rocket:Rocket
	Field orb:Orb

	Field orb_toggle:Bool

	Field r_target:Model

	Field lastvel:Vec3f
	Field prevvel:Vec3f
	
	Field fuel_color:Color = Color.Green

	Field joy:Joystick
	
	Method New (title:String, width:Int, height:Int, flags:WindowFlags)

		Super.New (title, width, height, flags)
	
		cam						= New Camera
		cam.Near				= 0.01
		cam.Far					= 1000
		
		' Temp bug workaround!
		
		cam.Viewport = Window.Rect
		
		light					= New Light
		light.CastsShadow		= True
		light.Range				= 1000
		light.Color = Color.White
		light.Move (-25, 100, 50)


				
		
		' TEMP - move into complete new object w/physics, etc...
		
		Local g:Ground = New Ground ()
		
		ground = g.LoadTerrain ("asset::height.png")
		
		ground.Move (0, -10, 0)

		Local ground_collider:TerrainCollider		' Bullet physics collider
		Local ground_body:RigidBody					' Bullet physics body

		ground_collider	= ground.AddComponent <TerrainCollider> ()
		ground_body		= ground.AddComponent <RigidBody> ()

		ground_collider.Heightmap	= g.heightmap
		ground_collider.Bounds		= g.height_box
		
		ground_body.Mass = 0.0

		ground_body.CollisionMask	= COLL_TERRAIN
		ground_body.CollisionGroup	= TERRAIN_COLLIDES_WITH
		
		light.PointAt (ground)

		scene 				= Scene.GetCurrent ()
		scene.AmbientLight	= Color.White * 0.75
		scene.ClearColor	= Color.Sky * 0.75
		
		' Halve gravity...
		
		scene.World.Gravity = scene.World.Gravity * New Vec3f (1.0, 0.5, 1.0)

		rocket	= RebuildRocket ()

'		cam.Parent = rocket.model
'		cam.Position = New Vec3f (0.0, 10.0, -25.0)
'		cam.Parent = Null
		
'		cam.Parent = rocket.model
'		cam.Move (0, 5, -25)
'		cam.PointAt (rocket.model)
		
		r_target = Model.CreateSphere (1, 32, 32, New PbrMaterial (Color.Red))
		r_target.Alpha = 0.5
		r_target.Material.CullMode = CullMode.None
		r_target.Visible = False
		
		lastvel = New Vec3f (0, 0, 10)
		prevvel = lastvel

		Local tpad:Pad
		
		' Start pad, no gem:
		
		tpad = New Pad (0.0, 10.0, 0.0)
		
		' Others (skipped param is x/z size)...
		
		tpad = New Pad (-20.0, -9.0, 10.0,, Color.Red)
		tpad = New Pad (40.0, -9.0, 25.0,, Color.Yellow)
		tpad = New Pad (80.0, -9.0, 75.0,, Color.Orange)
		tpad = New Pad (0.0, -9.0, 50.0,, Color.Green)
		tpad = New Pad (100.0, 50.0, 240.0,, Color.Magenta)
		tpad = New Pad (-105.0, 54.5, 235.0,, Color.Gold)
		tpad = New Pad (-230.0, 9.0, 157.0,, Color.Violet)
		tpad = New Pad (111.0, -9, -160.0,, Color.Black)
		tpad = New Pad (-70.0, 37.5, -31.0,, Color.HotPink)

		'Local test:Joystick = Joystick.Open (1)
		'Print test.Name
		
		' Try find an Xbox gamepad, use first one found...
		
		For Local loop:Int = 0 Until Joystick.NumJoysticks ()
			joy = Joystick.Open (loop)
			Print joy.Name
			If Not joy.Name.StartsWith ("XInput Controller #")
				joy.Close ()
				joy = Null
			Else
				Exit ' Got it!
			Endif
		Next

		scene.Update () ' Fixes missing rocket on directional input at startup;
						' Believe body needs update before applying impulse!

	End

	Method RebuildRocket:Rocket (x:Float = 0.0, y:Float = 20.0, z:Float = 0.0, radius:Float = 1.2, length:Float = 4.0, mass:Float = 10.0)
		Return New Rocket (x, y, z, radius, length, mass)
	End

	Method RebuildOrb:Orb (rocket:Rocket, distance:Float = 10.0, mass:Float = 8.0)
		Return New Orb (rocket, distance, mass)
	End

	Method UpdateGame ()

		If SpaceGem.SpaceGemList
		
			For Local sg:SpaceGem = Eachin SpaceGem.SpaceGemList
				
				sg.model.Rotate (2.0, 2.0, 2.0)
				
				If sg.model.Position.Distance (rocket.model.Position) < 4.0
					
					If SpaceGem.Collected
						SpaceGem.Collected_Channel = SpaceGem.Collected.Play (False)
						SpaceGem.Collected_Channel.Volume = 0.5
					Endif
					
					sg.model?.Destroy ()
					SpaceGem.SpaceGemList.Remove (sg)
					
				Endif
				
			Next
			
		Endif
		
		If rocket.exploded
			cam.Move (New Vec3f (0.0, 0.05, -0.05))
			cam.PointAt (rocket.model)

		Else
		
			' Camera positioning...
			
			prevvel = lastvel
			
			If rocket.body.LinearVelocity.XZ.Length > 10.0 ' TEMP
				lastvel = rocket.body.LinearVelocity
			Endif
			
			r_target.Position = rocket.model.Position - lastvel
	
			cam.Move ((r_target.Position - cam.Position) * 0.05, True)
			cam.PointAt (rocket.model)
		
		Endif
		
		If SmokeParticle.ParticleList
		
			For Local sp:SmokeParticle = Eachin SmokeParticle.ParticleList
			
				sp.model.Alpha = sp.model.Alpha * 0.9
				
				If sp.model.Alpha < 0.1
					sp.model.Destroy ()
					sp.body = Null
					SmokeParticle.ParticleList.Remove (sp)
				Endif
				
			Next
			
		Endif

		' Ground alpha - TEMP
				
		If Keyboard.KeyHit (Key.G)
			
			If ground.Alpha = 1.0
				ground.Alpha = 0.25
			Else
				ground.Alpha = 1.0
			Endif
			
		Endif

		If Keyboard.KeyHit (Key.O)

			orb_toggle = Not orb_toggle
			
			If orb_toggle
				orb = RebuildOrb (rocket)	
			Else
				orb?.Destroy ()
				orb = Null
			Endif
			
		Endif
		
		If Keyboard.KeyHit (Key.R) Or (joy And joy.Attached And joy.ButtonPressed (7))

			If SmokeParticle.ParticleList Then SmokeParticle.ParticleList.Clear ()

			If PhysicsTri.PhysicsTriList

				For Local pt:PhysicsTri = Eachin PhysicsTri.PhysicsTriList
					pt.Destroy ()
				Next

				PhysicsTri.PhysicsTriList.Clear ()

			Endif

			orb?.Destroy ()
			orb = Null

			' Store LOCAL position and orientation prior to un-parenting...
			
'			Local tcamlp:Vec3f = cam.LocalPosition
'			Local tcamlbas:Mat3f = cam.LocalBasis

'			Local tctamlp:Vec3f = cam_target.LocalPosition
'			Local tctamlbas:Mat3f = cam_target.LocalBasis
			
'			cam.Parent = Null
'			cam_target.Parent = Null
			
			rocket.Destroy ()

			rocket = RebuildRocket ()

			'cam.Parent = rocket.model

			cam.Position = New Vec3f (0.0, 10.0, -25.0)
			
'			cam_target.Parent = rocket.model
'			cam_target.Move (0, 0, -25)
'			cam_target.Position = cam.Position
		'	
			
			' Restore LOCAL position and orientation...
			
'			cam.LocalPosition = tcamlp
'			cam.LocalBasis = tcamlbas

'			cam_target.LocalPosition = tctamlp
'			cam_target.LocalBasis = tctamlbas
			
			If orb_toggle
				orb = RebuildOrb (rocket)
			Else
				orb?.Destroy ()
				orb = Null
			Endif
			
			scene.Update ()
			
		Endif
	
		Local boosting:Bool = False
		
		If rocket.fuel
		
			' KEYBOARD
			
			If Keyboard.KeyDown (Key.Left)
				rocket.PitchLeft (cam, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Right)
				rocket.PitchRight (cam, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Up)
				rocket.PitchForward (cam, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Down)
				rocket.PitchBack (cam, 0.75)
			Endif
	
			If Keyboard.KeyHit (Key.H)
				rocket.fuel = rocket.fuel * 0.5
			Endif
	
			If Keyboard.KeyDown (Key.Space)
			
				boosting = True
				
				If rocket.boost_channel.Volume < 1.0
					rocket.boost_channel.Volume = rocket.boost_channel.Volume + 0.1
					If rocket.boost_channel.Volume > 1.0 Then rocket.boost_channel.Volume = 1.0
				Endif
				
				rocket.Boost (0.0, rocket.body.Mass * rocket.boost_factor, 0.0)
				New SmokeParticle (rocket)
				
				rocket.fuel = rocket.fuel - (0.0375 * 0.5) ' Half full analogue controls' rate
				If rocket.fuel < 25.0 Then rocket.alert_channel.Volume = 0.2
				
				If rocket.fuel < 0.0
					rocket.fuel = 0.0
					rocket.boost_channel.Volume = 0.0
					boosting = False
				Endif
				
			Endif
			
			' JOYSTICK
			
			If joy And joy.Attached
			
	'			Print joy.GetAxis (0) ' Left stick left/right
				'Print joy.GetAxis (1) ' Left stick up/down (-1 = back, +1 = forward)
				
				Local jpitch:Float = joy.GetAxis (1)
				
				If jpitch > 0.05 Then rocket.PitchBack (cam, jpitch)
				If jpitch < -0.05 Then rocket.PitchForward (cam, Abs (jpitch))
				
				Local jlr:Float = joy.GetAxis (0)
				
				If jlr > 0.05 Then rocket.PitchRight (cam, jlr)
				If jlr < -0.05 Then rocket.PitchLeft (cam, Abs (jlr))
				
	'			Print joy.GetAxis (2) ' Left trigger
	'			Print joy.GetAxis (3) ' Right stick left/right
	'			Print joy.GetAxis (4) ' Right stick up/down
	'			Print joy.GetAxis (5) ' Right trigger (-1 = nothing, +1 = full)
	
				Local jyraw:Float = joy.GetAxis (5)
				Local jy:Float = (jyraw + 1) * 0.5
				
				If rocket.boost_channel.Volume < jy
					rocket.boost_channel.Volume = jy
				Endif
				
	'			Print jy ' 0-2
	'			Print ""
	
	'			If rocket.fuel And 
				If jyraw > -1.0
				
					boosting = True
					
					rocket.Boost (0.0, (rocket.body.Mass * rocket.boost_factor) * jy, 0.0)
					New SmokeParticle (rocket, jy)
					
					rocket.fuel = rocket.fuel - (0.0375 * jy)
					If rocket.fuel < 25.0 Then rocket.alert_channel.Volume = 0.2
					
					If rocket.fuel < 0.0
						rocket.fuel = 0.0
						rocket.boost_channel.Volume = 0.0
						boosting = False
					Endif
					
				Endif
				
			Endif
			
		Endif
		
		If Keyboard.KeyHit (Key.Escape)
			App.Terminate ()
		Endif

		If Not boosting
			rocket.boost_channel.Volume = rocket.boost_channel.Volume - 0.02
			If rocket.boost_channel.Volume < 0.0 Then rocket.boost_channel.Volume = 0.0
		Endif

	End

	Method ShadowText:Void (canvas:Canvas, s:String, x:Float, y:Float, fore:Color = Null, back:Color = Null)
		If Not fore Then fore = Color.White
		If Not back Then back = Color.Black
		canvas.Color = back
		canvas.DrawText	(s, x + 1, y + 1)
		canvas.Color = fore
		canvas.DrawText	(s, x, y)
	End

	Method RenderText (canvas:Canvas)
		
		canvas.Color = Color.White
		
		ShadowText (canvas, "FPS: " + App.FPS, 20.0, 20.0)

		ShadowText (canvas, "Left/right cursors to move rocket; SPACE to boost", 20.0, 60.0)
		ShadowText (canvas, "O to toggle orb", 20.0, 80.0)
		ShadowText (canvas, "R to reset!", 20.0, 100.0)

		if rocket.fuel = 0.0
			fuel_color = Color.Grey
		Elseif rocket.fuel > 50.0
			fuel_color = Color.Green
		Elseif rocket.fuel <= 25.0
			fuel_color = Color.Red
		Elseif rocket.fuel <= 50.0
			fuel_color = Color.Orange
		Endif
		
		ShadowText (canvas, "Fuel: " + Int (rocket.fuel), 20.0, 140.0, fuel_color)

		canvas.Color = Color.White

'		ShadowText (canvas, "Scene update: " + scene.UpdateRate, 20.0, 160.0)

'		ShadowText (canvas, Degrees (rocket.model.GetRotation ().Yaw), 20, 180)
'		ShadowText (canvas, Degrees (rocket.model.GetRotation ().Pitch), 20, 200)

'		ShadowText (canvas, rocket.model.Position, 20, 180)
		
'		ShadowText (canvas, "vel: " + rocket.body.LinearVelocity, 20.0, 140.0)
'		ShadowText (canvas, "dist: " + r_target.Position.Distance (rocket.model.Position), 20.0, 160.0)

'		ShadowText (canvas, "rtpos: " + r_target.Position, 20.0, 180.0)
'		ShadowText (canvas, "cmpos: " + cam.Position, 20.0, 200.0)

'		ShadowText (canvas, "lastvel: " + lastvel, 20.0, 220.0)
'		ShadowText (canvas, "rockvel: " + rocket.body.LinearVelocity.Normalize (), 20.0, 240.0)
'		ShadowText (canvas, "max    : " + (Max (rocket.body.LinearVelocity.Length, lastvel.Length)), 20.0, 260.0)


	End

	Method OnRender (canvas:Canvas) Override

		UpdateGame ()
		
		RequestRender ()
		
		scene.Update ()
		scene.Render (canvas)

'		canvas.Color = Color.Blue

			' Need to translate orb.constraint.Pivot:Vec3f to world position somehow -- this one isn't working!
			
	'		Local rcpos:Vec2f = cam.ProjectToViewport (orb.model.Position + orb.constraint.Pivot)
	'		DrawCross (canvas, rcpos.x, rcpos.y)

'		canvas.Color = Color.Yellow

'			Local ocpos:Vec2f = cam.ProjectToViewport (orb.model.Position + orb.constraint.ConnectedPivot)
'			DrawCross (canvas, ocpos.x, ocpos.y)
			
		canvas.Color = Color.Lime
		
			Local rpos:Vec2f = cam.ProjectToViewport (rocket.model.Position)
			Local opos:Vec2f
			
			If orb
				opos = cam.ProjectToViewport (orb.model.Position)
				canvas.DrawLine (rpos, opos)
			Endif
			
		RenderText (canvas)
		
	End

End

Function PixmapFormat:String (pixmap:Pixmap)

	Select pixmap.Format
		Case PixelFormat.Unknown
			Return "PixelFormat.Unknown"
		Case PixelFormat.Depth16
			Return "PixelFormat.Depth16"
		Case PixelFormat.Depth24
			Return "PixelFormat.Depth24"
		Case PixelFormat.Depth32
			Return "PixelFormat.Depth32"
		Case PixelFormat.IA16
			Return "PixelFormat.IA16"
		Case PixelFormat.RGB24
			Return "PixelFormat.RGB24"
		Case PixelFormat.RGBA32F
			Return "PixelFormat.RGBA32F"
		Case PixelFormat.RGBA16F
			Return "PixelFormat.RGBA16F"
		Case PixelFormat.I8
			Return "PixelFormat.I8"
		Case PixelFormat.A8
			Return "PixelFormat.A8"
		Case PixelFormat.IA8
			Return "PixelFormat.IA8"
		Case PixelFormat.RGB8
			Return "PixelFormat.RGB8"
		Case PixelFormat.RGBA8
			Return "PixelFormat.RGBA8"
		Case PixelFormat.RGBA32
			Return "PixelFormat.RGBA32"
	End

	Return ""

End

Function Run3D (title:String, width:Int, height:Int, flags:WindowFlags = WindowFlags.Center)

	New AppInstance
	New Game (title, width, height, flags)

	App.Run ()

End

Function Main ()
	Run3D ("Bust!", 1024, 768, WindowFlags.Center)
'	Run3D ("Bust!", 1920, 1080, WindowFlags.Fullscreen)
End
