
#Import "<std>"
#Import "<mojo3d>"
#Import "assets/glass.wav" 	' CC0 by ngruber, https://freesound.org/people/ngruber/sounds/204777/

Using std..
Using mojo..
Using mojo3d..

' ----------------------------------------
' Application name...
' ----------------------------------------

Global AppName:String = "Shatter!"

' TODO: Return array of tri models??

' Single tri...

' Collision types

Const COLL_NOTHING:Short			= 0
Const COLL_GROUND:Short				= 1
Const COLL_TRI:Short				= 2
Const COLL_BALL:Short				= 4

' Collision groups

Const GROUND_COLLIDES_WITH:Short	= COLL_TRI | COLL_BALL
Const TRI_COLLIDES_WITH:Short		= COLL_GROUND ' NOT with other tris! Too slow!
Const BALL_COLLIDES_WITH:Short		= COLL_GROUND

' Maybe return as rects so Boxf collisions can be used?

Function ModelFromTriangle:Model (in_model:Model, index:UInt)

		Local mesh:Mesh = in_model.Mesh
		
		Local tri_model:Model = New Model
		
			tri_model.Material = in_model.Material' New PbrMaterial (Color.Red)
'			Cast <PbrMaterial> (tri_model.Material).ColorFactor = Color.Orange
			
			tri_model.Material.CullMode = CullMode.None
 
		Assert (index + 2 < mesh.NumIndices , "Index too high") ' Think that's right...
		
		Local indices:UInt [] = mesh.GetIndices ()
		
		Local tri_verts:Vertex3f [] = New Vertex3f [3]
		
			' mesh-local co-ords...
			
			tri_verts [0] = mesh.GetVertex (indices [index + 0])
			tri_verts [1] = mesh.GetVertex (indices [index + 1])
			tri_verts [2] = mesh.GetVertex (indices [index + 2])
		
		Local tri_indices:UInt [] = New UInt [3]
		
			tri_indices [0] = 0
			tri_indices [1] = 1
			tri_indices [2] = 2
		
		Local tri_mesh:Mesh = New Mesh (tri_verts, tri_indices)
		
		tri_mesh.UpdateNormals ()
		tri_mesh.UpdateTangents ()
 
		tri_model.Mesh = tri_mesh
 
 		tri_model.Parent = in_model
 		
	Return tri_model
 
End

Class PhysicsTri

	Field model:Model
	Field body:RigidBody
	Field collider:BoxCollider
	
End

Class Ground ' WIP! Add physics, etc...

	Field ground:Model
	Field ground_pixels:Pixmap

	Field heightmap:Pixmap
	Field terrain_material:PbrMaterial

	Field height_box:Boxf
	
	Method LoadTerrain:Model (hmap:String)

		Local ground_pixels:Pixmap = New Pixmap (256, 256, PixelFormat.RGBA8)
		ground_pixels.Clear (Color.Green * 0.5)
		
		Local pixel_toggle:Int = 0
		
		For Local gp_y:Int = 0 Until ground_pixels.Height
			For Local gp_x:Int = 0 Until ground_pixels.Width
				If pixel_toggle Then ground_pixels.SetPixel (gp_x, gp_y, Color.SeaGreen * New Color (1.0, 1.2, 0.75))
				pixel_toggle = 1 - pixel_toggle
			Next
			pixel_toggle = 1 - pixel_toggle
		Next
		
		heightmap = Pixmap.Load (hmap)
		
		If heightmap.Format <> PixelFormat.I8
			Print ""
			Print "*** MEDIA WARNING: Converting heightmap; should be supplied in PixelFormat.I8 format! (See PixelFormat docs.) ***"
			Print ""
			heightmap = heightmap.Convert (PixelFormat.I8)
			'Print heightmap.Save ("C:/Users/James/Desktop/height.png") ' Returns True if saved to asset:: even though it fails!
		Endif
		
		Local terrain_material:PbrMaterial = New PbrMaterial ()
		terrain_material.ColorTexture = New Texture (ground_pixels, TextureFlags.None)
		
		Local terrain_height:Float = 64.0
		
		height_box = New Boxf (-heightmap.Width * 0.5, 0, -heightmap.Height * 0.5, heightmap.Width * 0.5, terrain_height, heightmap.Height * 0.5)

		Return Model.CreateTerrain (heightmap, height_box, terrain_material)
		
	End
	
End

Class Game Extends Window
	
	Const SHIFT_BOOST:Float = 5.0
	
 	Field camera_boost:Float = 1.0
 	
	' Basic 3D scene requirements...
	
	Field scene:Scene
	Field camera:Camera
	Field light:Light
 
	' Test ball...
	
	Field ball:Model
	
	Field sound:Sound
	
	Field b_coll:SphereCollider
	Field b_body:RigidBody
	
	Field exploded:Bool
	Field run_physics:Bool
	Field lastvel:Vec3f

	Field ground:Model
	Field ground_pixels:Pixmap

	Method New (title:String, width:Int, height:Int, flags:WindowFlags)
		
		Super.New (title, width, height, flags)
		
		sound = Sound.Load ("asset::glass.wav")
		
		scene = Scene.GetCurrent () ' Important!
		
		camera = New Camera
 
			' Camera settings...
			
			camera.Near = 0.1
		
			' Camera position...
			
			camera.Move (0, 21.5, -20)
		
			'camera.Viewport = Window.Rect
			
		light = New Light
		
			light.Move (-100, 100, -100)

		Local g_box:Boxf = New Boxf (-100, -5, -100, 100, 5, 100)
		
		Local ground:Model = Model.CreateBox (g_box, 4, 4, 4, New PbrMaterial (Color.Green * 0.5))

		light.PointAt (ground)
		
		
		Local g_coll:BoxCollider = ground.AddComponent <BoxCollider> ()
		
		g_coll.Box = g_box
		
		Local g_body:RigidBody = ground.AddComponent <RigidBody> ()
		
		g_body.Mass = 0.0
		
		g_body.CollisionMask = COLL_GROUND
		g_body.CollisionGroup = GROUND_COLLIDES_WITH

	
		Local size:Float = 4.0
		
		ball = Model.CreateSphere (size * 0.5, 36, 36, New PbrMaterial (Color.Aluminum))

			ball.Move (-25, 20, 25)
			ball.Alpha = 0.3
			Cast <PbrMaterial> (ball.Material).MetalnessFactor = 1.0
			
		b_coll = ball.AddComponent <SphereCollider> ()
		b_body = ball.AddComponent <RigidBody> ()
		b_coll.Radius = size * 0.5

		b_body.CollisionMask = COLL_BALL
		b_body.CollisionGroup = BALL_COLLIDES_WITH
		
		' TODO: Copy velocity from main ball...
		
		b_body.Mass = 10.0
		
		b_body.ApplyImpulse (New Vec3f (0.0, 0, -10))
		
		ball.Collided += Lambda (body:RigidBody)
			
			If exploded Return ' 0,0,0 at collision

			sound?.Play ()
			
			Local SKIPPER:Int = 5 ' Skip every SKIPPER triangles for speed
			
			'Local dir:Vec3f = New Vec3f (0, 0, 5)
			Local thickener:Boxf = New Boxf (0.0, -1.0, 0.0, 0.0, 1.0, 0.0)
			
			For Local loop:UInt = 0 Until ball.Mesh.NumIndices Step 3 * SKIPPER
				
				Local ptri:PhysicsTri = New PhysicsTri
				
				ptri.model = ModelFromTriangle (ball, loop)
				ptri.model.Scale = New Vec3f (1.2, 1.2, 1.2)
				
				ptri.model.Parent = Null
	
				ptri.collider = ptri.model.AddComponent <BoxCollider> ()
				ptri.collider.Box = ptri.model.Mesh.Bounds' + thickener
				
				'Print ptri.model.Mesh.Bounds
				
				ptri.body				= ptri.model.AddComponent <RigidBody> ()
				ptri.body.Mass			= 1.0
				ptri.body.Restitution	= 0.25
				ptri.body.Friction		= 1.0
				ptri.body.AngularDamping		= 1.0
	
				ptri.body.CollisionMask = COLL_TRI
				ptri.body.CollisionGroup = TRI_COLLIDES_WITH
				
				ptri.body.ApplyImpulse (b_body.LinearVelocity + (ball.Basis * New Vec3f (Rnd (-10, 10), 10.0, Rnd (-1.0, 10.0))))
				
			Next
			
			exploded = True
			'b_body = Null
			
		End






	End

	Method UpdateGame:Void ()

		If ball
			camera.PointAt (ball)
		Endif

		If exploded
			
			If ball
				ball.Alpha = ball.Alpha - 0.15 ' Very subtle fade hides the join between there and not-there!
				If ball.Alpha <= 0.0
					ball.Visible = False
'					ball.Destroy ()
'					ball = Null
				Endif
			Endif
			
		Endif
		
	End
	
	Method OnRender (canvas:Canvas) Override
 
	 	ProcessInput ()
 		UpdateGame ()
 
		RequestRender ()
		
		If run_physics
			
			' Nope!
			
			'Print b_body.LinearVelocity
			
			' Nope!
			
			If b_body.AngularVelocity <> New Vec3f (0, 0, 0)
				lastvel = b_body.LinearVelocity
			Endif
			
			scene.Update ()
			
		Endif
		
		scene.Render (canvas)

		canvas.DrawText (App.FPS, 20, 20)
		If Not run_physics Then canvas.DrawText ("Hit SPACE to drop glass ball! Only runs once...", 20, 60)
		
	End

	Method ProcessInput:Void ()

		If Keyboard.KeyDown (Key.LeftShift)
			camera_boost = SHIFT_BOOST
		Else
			camera_boost = 1.0
		Endif

		If Keyboard.KeyHit (Key.Space)
			b_body.ApplyImpulse (New Vec3f (0.0, 0.0, -10.0))
			run_physics = True
		Endif
		
		If Keyboard.KeyHit (Key.Escape) Then App.Terminate ()
		
		If Keyboard.KeyDown (Key.A)
			camera.Move (0.0, 0.0, 0.1 * camera_boost)
		Endif
 
		If Keyboard.KeyDown (Key.Z)
			camera.Move (0.0, 0.0, -0.1 * camera_boost)
		Endif
 
		If Keyboard.KeyDown (Key.Left)
			camera.Rotate (0.0, 1.0, 0.0)
		Endif
 
		If Keyboard.KeyDown (Key.Right)
			camera.Rotate (0.0, -1.0, 0.0)
		Endif
 
		If Keyboard.KeyDown (Key.Up)
			camera.Rotate (1.0, 0.0, 0.0, True)
		Endif
 
		If Keyboard.KeyDown (Key.Down)
			camera.Rotate (-1.0, 0.0, 0.0, true)
		Endif

	End

End
 
Function Main ()
 
	' Windowed mode...
	
	Local width:Int			= 640
	Local height:Int		= 480
	
	Local flags:WindowFlags	= WindowFlags.Center
	
	New AppInstance
	
	New Game (AppName, width, height, flags)
	
	App.Run ()
		
End
