'Monkey 2 Splash Screen
'Author: Richard R Betson
'License: Public Domain


Namespace monkey2splash

#Import "assets/"
#Import "<std>"
#Import "<mojo>"


Using std..
Using mojo..


Class MyWindow Extends Window

	Field _monkey2logo:Image
	Field _monkey2title:Image	
	Field _light:Image
	Field mlp:Float
	Field _device_width:Float
	Field _device_height:Float

	
	Method New()
		Super.New( "Monkey 2 Splash Screen",1280,720, WindowFlags.Resizable | WindowFlags.Maximized )
	
		ClearColor=Color.Black
	
		
		'************ Notice ********** 
		'The specular and normal maps are loaded in reverse order.
		'This allows for the lighting effect I was after.
		'---------------------------------------------------------
		Self._monkey2logo=Image.LoadBump( "asset::monkey2logo.png","asset::monkey2logo_S.png","asset::monkey2logo_N.png", 1.5,False,Null,TextureFlags.FilterMipmap)
		Self._monkey2title=Image.LoadBump( "asset::monkey2title.png","asset::monkey2title_S.png","asset::monkey2title_N.png" ,100.5,False,Null,TextureFlags.FilterMipmap)
		Self._monkey2title.Handle=New Vec2f(.5,.5)
		
		Self._light=Image.LoadLight( "asset::light.png",Null,TextureFlags.Filter)
		Self._light.Handle=New Vec2f(.5,.5)

	End
	
	Method OnRender( canvas:Canvas ) Override
		
		Self._device_height=canvas.Viewport.BottomRight.Y
		Self._device_width=canvas.Viewport.BottomRight.X
	
		Self.mlp=Self.mlp+2.5
		If Self.mlp>600
			Self.mlp=600
		Endif
		
		If Keyboard.KeyHit(Key.Space) Then mlp=0
			
		canvas.AmbientLight=New Color(.6,.6,.6)
		
		canvas.BeginLighting()

			canvas.DrawImage(Self._monkey2logo,(Self._device_width*.5)-256,(Self._device_height*.5)-256)
			canvas.DrawImage(Self._monkey2title,(Self._device_width*.5),(Self._device_height*.5)+ 300)
			
			Self._light.Scale=New Vec2f( 15+(mlp*.1) ,15+(mlp*.1))
			Self._light.Color=New Color(.5,.5,.5)
			canvas.AddLight( Self._light , ((Self._device_width*.5)-880) + mlp, ((Self._device_height*.5)+306) + mlp)', 15+(mlp*.1) ,15+(mlp*.1)) 		

		canvas.EndLighting()

		
		canvas.DrawText("Hit spacebar to play splash.",10,10)

		App.RequestRender()
	End
	
End

Function Main()

	New AppInstance
	
	New MyWindow
	
	App.Run()
End
